/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelTaskletBase;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.CertSignReq;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.certs.SelfSignedServerCert;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.certs.SubjectAltNames;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

class CertMgtPanelUtils
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTMPUD";
    private static final String TRACE_MASKF = "XCRTMPUF";
    private static final String TRACE_MASKT = "XCRTMPUT";

    private CertMgtPanelUtils() {
    }

    public static void main(String[] args) {
    }

    static void sendTaskletRequest(String actionCommand, Serializable data, Serializable data2, ServerCert certificate, PanelBean bean) {
        PanelTaskletRequest request = null;
        Trace.trace(TRACE_MASKT, "<->sendTaskletRequest(" + actionCommand + ", " + data + ", " + data2 + ", " + certificate + ", " + bean + ")");
        request = new PanelTaskletRequest(bean.getBeanName() + '.' + actionCommand);
        request.setData("Source", bean.getBeanName());
        request.setData("Action", actionCommand);
        request.setData("Data", data);
        request.setData("Data2", data2);
        request.setData("Cert", certificate);
        bean.postTaskletRequest(request);
    }

    static void sendTaskletRequest(String actionCommand, Serializable data, PanelBean bean) {
        CertMgtPanelUtils.sendTaskletRequest(actionCommand, data, null, null, bean);
    }

    static void sendCancelRequest(PanelBean bean) {
        PanelTaskletRequest request = null;
        Trace.trace(TRACE_MASKT, "<->sendCancelRequest(" + bean + ")");
        request = new PanelTaskletRequest(bean.getBeanName());
        request.setCanceled();
        bean.postTaskletRequest(request);
    }

    static void createItemDescriptor(ItemDescriptor[][] table, int i, String property, String value) {
        ItemDescriptor[] row = null;
        Trace.trace(TRACE_MASKT, "<->createItemDescriptor(" + table + ", " + i + ", " + property + ", " + value + ")");
        row = new ItemDescriptor[]{new ItemDescriptor(i + ".ServerCertTable.Name", property), new ItemDescriptor(i + ".ServerCertTable.Value", value)};
        table[i] = row;
    }

    static ValueDescriptor createValueDescriptor(String listBoxName, String value) {
        Trace.trace(TRACE_MASKT, "<->createValueDescriptor(" + listBoxName + ", " + value + ")");
        return new ValueDescriptor("Name." + listBoxName + "." + value, value);
    }

    static SubjectAltNames getSubjectAltNames(ValueDescriptor[] dnsListBox, ValueDescriptor[] ipAddrListBox) {
        int i;
        SubjectAltNames result = null;
        result = new SubjectAltNames();
        if (dnsListBox != null) {
            for (i = 0; i < dnsListBox.length; ++i) {
                result.addDNSName(dnsListBox[i].getTitle());
            }
        }
        if (ipAddrListBox != null) {
            for (i = 0; i < ipAddrListBox.length; ++i) {
                result.addIPAddrName(ipAddrListBox[i].getTitle());
            }
        }
        return result;
    }

    static ItemDescriptor[][] createCertTable(ServerCert certificate, boolean changesPending) {
        ItemDescriptor[][] result = null;
        int version = 0;
        BigInteger serialNumber = null;
        CertPrincipal issuer = null;
        CertPrincipal subject = null;
        SubjectAltNames subjectAltNames = null;
        Date notBeforeDate = null;
        Date notAfterDate = null;
        Integer days = null;
        if (certificate != null) {
            result = new ItemDescriptor[7][2];
            version = certificate.getVersion();
            serialNumber = certificate.getSerialNumber();
            issuer = certificate.getIssuerX500Principal();
            subject = certificate.getSubject();
            subjectAltNames = certificate.getSubjectAltNames();
            notBeforeDate = certificate.getNotBefore();
            notAfterDate = certificate.getNotAfter();
            days = certificate.getNumOfDays();
            CertMgtPanelUtils.createItemDescriptor(result, 0, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "versionProperty").toString(), version != -1 ? String.valueOf(version) : (changesPending ? new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailableYet").toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString()));
            CertMgtPanelUtils.createItemDescriptor(result, 1, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "serialNumberProperty").toString(), serialNumber != null ? serialNumber.toString() : (changesPending ? new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailableYet").toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString()));
            CertMgtPanelUtils.createItemDescriptor(result, 2, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "issuerProperty").toString(), issuer != null ? issuer.toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString());
            CertMgtPanelUtils.createItemDescriptor(result, 3, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "validFromProperty").toString(), notBeforeDate != null ? new SimpleDateFormat().format(notBeforeDate) : (changesPending ? new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailableYet").toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString()));
            CertMgtPanelUtils.createItemDescriptor(result, 4, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "validUntilProperty").toString(), notAfterDate != null ? new SimpleDateFormat().format(notAfterDate) : (days != null ? days.toString() + " " + new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "fromTimeOfApply").toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString()));
            CertMgtPanelUtils.createItemDescriptor(result, 5, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "subjectProperty").toString(), subject != null ? subject.toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString());
            CertMgtPanelUtils.createItemDescriptor(result, 6, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "subjectAltNamesProperty").toString(), subjectAltNames != null ? subjectAltNames.toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "none").toString());
        } else {
            result = new ItemDescriptor[0][0];
        }
        return result;
    }

    static boolean showLocalizedQuestionMessageBox(String title, String prompt, PanelTasklet tasklet) {
        LocalizableText answer = null;
        boolean result = false;
        Object[] subs = null;
        subs = new Object[]{prompt};
        try {
            answer = tasklet.showMessageBox(true, new LocalizableText(title), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0070", subs), MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
            if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                result = true;
            }
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
        return result;
    }

    static void showErrorMessageBox(MessageText messageText, PanelTaskletResponse response, PanelTasklet tasklet) {
        try {
            tasklet.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0020"), messageText, MsgType.ERROR_MESSAGE, null);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
    }

    static void showInfoMessageBox(MessageText messageText, PanelTaskletResponse response, PanelTasklet tasklet) {
        try {
            tasklet.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0023"), messageText, MsgType.INFORMATION_MESSAGE, null);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
    }

    static void showNotSupportedMessageBox(PanelTaskletResponse response, PanelTasklet tasklet) {
        try {
            tasklet.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0001"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0002"), MsgType.INFORMATION_MESSAGE, null);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
        response.noAction();
    }

    static void showNoChangesMessageBox(PanelTaskletResponse response, PanelTasklet tasklet) {
        CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0028"), response, tasklet);
    }

    static boolean showQuestionMessageBox(String titleKey, String questionKey, PanelTasklet tasklet) {
        return CertMgtPanelUtils.showQuestionMessageBox(titleKey, questionKey, null, tasklet);
    }

    static boolean showQuestionMessageBox(String titleKey, String questionKey, String[] subs, PanelTasklet tasklet) {
        boolean result = false;
        LocalizableText answer = null;
        try {
            answer = tasklet.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", titleKey), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", questionKey, subs), MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
            if (CommonMsgInterface.YES_BUTTON.equals(answer)) {
                result = true;
            }
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
        return result;
    }

    static boolean showReadyToWriteBox(PanelTasklet tasklet) {
        LocalizableText answer = null;
        boolean result = false;
        try {
            answer = tasklet.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0023"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0041"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
            if (answer.equals(CommonMsgInterface.OK_BUTTON)) {
                result = true;
            }
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
        return result;
    }

    static int parseNumOfDays(String s) throws IllegalUserDataException {
        int temp = 0;
        Object[] subs = null;
        int maxDays = 0;
        try {
            try {
                maxDays = CertUtils.wholeDaysGreater(new GregorianCalendar(2037, 11, 31).getTime(), new GregorianCalendar().getTime());
                if (maxDays <= 0) {
                    throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0051").toString());
                }
            }
            catch (HException e) {
                throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0051").toString());
            }
            temp = new Integer(s);
            if (temp < 1 || temp > maxDays) {
                subs = new String[]{String.valueOf(maxDays)};
                throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0074", subs).toString());
            }
            return temp;
        }
        catch (NumberFormatException e) {
            throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0058").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createCSR(PanelTaskletResponse response, CertMgtPanelTaskletBase panelTasklet, String deviceName, ServerCert serverCert, int numOfDisposes, String panelToUpdate) throws MediaDeviceException, MediaServicesUtilException {
        String errorMessage = null;
        HashMap<String, SelfSignedServerCert> taskletData = null;
        MediaDevice mediaDevice = null;
        SelfSignedServerCert tempCertificate = null;
        CertPrincipal tempSubject = null;
        MediaDeviceIdentifier chosenDevice = null;
        File mediaMountPointFile = null;
        String mediaMountPoint = null;
        String savedKeyFileName = null;
        CertSignReq certSignReq = null;
        MediaDeviceIdentifier[] devices = null;
        String question = null;
        boolean shutdownStarted = false;
        boolean errorWritingCSR = false;
        devices = MediaServices.getMediaServices().getMediaDeviceIdentifiers();
        if (devices == null) return;
        chosenDevice = CertMgtPanelUtils.getChosenDevice(devices, deviceName);
        if (chosenDevice == null) {
            CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0044"), response, panelTasklet);
            response.noAction();
            return;
        }
        if (CertMgtPanelUtils.showReadyToWriteBox(panelTasklet)) {
            errorMessage = null;
            try {
                tempCertificate = CertUtils.createCert(serverCert, true);
            }
            catch (UnknownHostException e) {
                errorMessage = "0063";
            }
            catch (HException e) {
                errorMessage = "0064";
            }
            if (tempCertificate != null) {
                block28: {
                    if (errorMessage != null) {
                        CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", errorMessage), response, panelTasklet);
                        response.noAction();
                        return;
                    }
                    tempSubject = tempCertificate.getSubject();
                    certSignReq = new CertSignReq(tempSubject != null ? tempSubject.getCountry() : null, tempSubject != null ? tempSubject.getState() : null, tempSubject != null ? tempSubject.getLocality() : null, tempSubject != null ? tempSubject.getOrg() : null, tempSubject != null ? tempSubject.getOrgUnit() : null, tempSubject != null ? tempSubject.getHostName() : null, tempSubject != null ? tempSubject.getEMailAddr() : null, tempCertificate.getAlternateDNSNames(), tempCertificate.getIPAddresses());
                    try {
                        mediaDevice = null;
                        panelTasklet.setBeingWrittenTo(true);
                        mediaDevice = new MediaServicesUtil(panelTasklet).prepareMedia(chosenDevice, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "certMgtTasklet"), true, null);
                        mediaMountPointFile = mediaDevice.getMountPoint();
                        try {
                            errorWritingCSR = false;
                            mediaMountPoint = mediaMountPointFile.getCanonicalPath();
                            savedKeyFileName = CertUtils.getConfiguredSavedKeyFileName();
                            certSignReq.writeToFile(mediaMountPoint + File.separator + "server.csr", savedKeyFileName, true, false);
                        }
                        catch (IOException e) {
                            errorWritingCSR = true;
                            CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0046"), response, panelTasklet);
                            response.noAction();
                        }
                        catch (HException e) {
                            errorWritingCSR = true;
                            CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0046"), response, panelTasklet);
                            response.noAction();
                        }
                        Object var22_31 = null;
                        if (mediaDevice == null) break block28;
                    }
                    catch (Throwable throwable) {
                        Object var22_32 = null;
                        if (mediaDevice != null) {
                            mediaDevice.unlock();
                        }
                        panelTasklet.setBeingWrittenTo(false);
                        throw throwable;
                    }
                    mediaDevice.unlock();
                }
                panelTasklet.setBeingWrittenTo(false);
                if (errorWritingCSR) return;
                question = panelToUpdate != null ? "0043" : "0071";
                if (CertMgtPanelUtils.showQuestionMessageBox("0042", question, panelTasklet)) {
                    if (panelToUpdate != null) {
                        response.setMultipleResponseMode();
                        int i = 0;
                        while (true) {
                            if (i >= numOfDisposes) {
                                taskletData = new HashMap<String, SelfSignedServerCert>();
                                taskletData.put("NEW_CERTIFICATE", tempCertificate);
                                response.update(panelToUpdate, taskletData);
                                return;
                            }
                            response.dispose();
                            ++i;
                        }
                    }
                    try {
                        CertUtils.doInstallSelfSigned(tempCertificate);
                        CertMgtPanelUtils.showInfoMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0033"), response, panelTasklet);
                        Trace.trace(TRACE_MASKF, "Replaced certificate successfully.. restarting");
                        try {
                            shutdownStarted = ShutdownManager.restartApplication(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", panelTasklet.toString()), new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "restartReason"), null);
                        }
                        catch (ShutdownInProcessException e) {
                            shutdownStarted = true;
                        }
                        if (!shutdownStarted) {
                            Trace.trace(TRACE_MASKF, "Shutdown request rejected by local user");
                        }
                        if (numOfDisposes > 1) {
                            response.setMultipleResponseMode();
                        }
                        int i = 0;
                        while (i < numOfDisposes) {
                            response.dispose();
                            ++i;
                        }
                        return;
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, e);
                        CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0034"), response, panelTasklet);
                        return;
                    }
                }
                if (numOfDisposes > 1) {
                    response.setMultipleResponseMode();
                }
                int i = 0;
                while (i < numOfDisposes) {
                    response.dispose();
                    ++i;
                }
                return;
            }
            CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", errorMessage != null ? errorMessage : "0046"), response, panelTasklet);
            response.noAction();
            return;
        }
        if (numOfDisposes > 1) {
            response.setMultipleResponseMode();
        }
        int i = 0;
        while (i < numOfDisposes) {
            response.dispose();
            ++i;
        }
    }

    static MediaDeviceIdentifier getChosenDevice(MediaDeviceIdentifier[] devices, String deviceName) {
        MediaDeviceIdentifier currentDevice = null;
        MediaDeviceIdentifier result = null;
        String currentDeviceName = null;
        for (int i = 0; i < devices.length; ++i) {
            currentDevice = devices[i];
            if (currentDevice == null || (currentDeviceName = currentDevice.getDeviceName()) == null || !currentDeviceName.equals(deviceName)) continue;
            result = currentDevice;
            break;
        }
        return result;
    }
}

